/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.yabn.elements;

import com.teamresourceful.yabn.elements.YabnException;
import java.util.HashMap;
import java.util.Map;

public enum YabnType {
    NULL(1),
    BOOLEAN_TRUE(2),
    BOOLEAN_FALSE(3),
    BYTE(4, true),
    SHORT(5, true),
    INT(6, true),
    LONG(7, true),
    DOUBLE(8, true),
    FLOAT(9, true),
    STRING(10, true),
    EMPTY_STRING(11),
    ARRAY(12, true),
    OBJECT(13, true),
    EMPTY_ARRAY(14),
    EMPTY_OBJECT(15),
    NULL_STRING(16, true),
    TYPED_ARRAY(17, true),
    DATALESS_TYPED_ARRAY(18, true);

    private static final Map<Byte, YabnType> LOOKUP;
    public final byte id;
    public final boolean hasData;

    private YabnType(int id) {
        this(id, false);
    }

    private YabnType(int id, boolean hasData) {
        this.id = (byte)id;
        this.hasData = hasData;
    }

    public static YabnType fromId(byte id) {
        YabnType type = LOOKUP.get(id);
        if (type == null) {
            throw new YabnException("Invalid YABN type id: " + id);
        }
        return type;
    }

    static {
        LOOKUP = new HashMap<Byte, YabnType>(){
            {
                for (YabnType type : YabnType.values()) {
                    this.put(type.id, type);
                }
            }
        };
    }
}

